IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Contratos_Generar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Contratos_Generar 
END
GO

CREATE PROCEDURE [dbo].[CPJ_Contratos_Generar] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por parmetro a traves del JSON*/
DECLARE @pFlagUsarTrans		TINYINT
DECLARE @pModoDebug			TINYINT
DECLARE @pId_Usuario		SMALLINT
DECLARE @pId_Tipo_Con		INT
DECLARE @pFecha_Desde		DATETIME
DECLARE @pFecha_Hasta		DATETIME
DECLARE @pId_Cliente		INT
DECLARE @pId_Grupo_Cont     CHAR(10)
DECLARE @pId_SubGrupo_Cont  CHAR(10)

SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Tipo_Con			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Id_Tipo_Con')), 0)
SET @pId_Usuario			= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), -1)
SET @pFecha_Desde			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Desde')),'19000101')
SET @pFecha_Hasta			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Hasta')),'19000101')
SET @pId_Cliente			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Grupo_Cont			= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Grupo_Cont')), '')
SET @pId_SubGrupo_Cont		= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_SubGrupo_Cont')), '')
/*FIN Variables recibidas por parmetro a traves del JSON*/


/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored			INT
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/
DECLARE @Id_Contrato INT

DECLARE @id_lista_precio		INT
/*Fin de Declaraciones Variables Locales */



BEGIN TRY

	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END
	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Contratos_Generar'
	END
	
	/*===================================================================*/


	/*===================================================================*/

	
	IF(@pId_Cliente = 0)  RAISERROR ('Id_Cliente can not be zero.', 16,  1 )
	IF(@pId_Tipo_Con = 0)  RAISERROR ('Id_Tipo_Con can not be zero.', 16,  1 )

		
	/*===================================================================*/
	
	IF(@pId_Usuario = 0)
	BEGIN
		SET @pId_Usuario = -1
	END


	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Inserto en Contratos.'
	END

	IF (@pFecha_Hasta='')
	BEGIN
	
		SET	@pFecha_Hasta= NULL
		PRINT @pFecha_Hasta
	END

	SET @id_lista_precio =(SELECT Id_Lista_Precio FROM Clientes WHERE Id_Cliente=@pId_Cliente)
	
	IF(@pId_Tipo_Con <> 0)
	BEGIN
		SET @Id_Contrato		= ISNULL((SELECT MAX(Id_Contrato) FROM Contratos), 0) + 1
		INSERT INTO Contratos 
		(Id_Contrato, Id_Tipo_Con, Id_Cliente, Fecha_Alta, Fecha_Desde, Fecha_Hasta, Id_Grupo_Cont, Id_SubGrupo_Cont, Id_Usuario_Alta, Activo, Id_Lista_Precio)
		VALUES
		(@Id_Contrato,@pId_Tipo_Con, @pId_Cliente, GETDATE(),@pFecha_Desde,@pFecha_Hasta, @pId_Grupo_Cont,@pId_SubGrupo_Cont,@pId_Usuario,1,@id_lista_precio)
	END


	
	/*===================================================================*/	
	
	SET @rtaMsjStored		=	'{' +
								dbo.CF_Json_ParsearVariable('id_contrato', @Id_Contrato, 'INT')  + ',' +
								dbo.CF_Json_ParsearVariable('id_cliente', @pId_Cliente, 'INT')  + ',' +
								'}'
								
	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,@Id_Contrato		AS ErrorLine		
			,@rtaMsjStored	AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Contratos_Generar'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0 
	BEGIN
		ROLLBACK
	END

	RETURN 9999
END CATCH

RETURN 0

--Ejemplo de uso
--EXEC CPJ_Contratos_Generar '{"FlagUsarTrans":"0", "ModoDebug":"1", "Id_Usuario":"-1", "Id_Tipo_Con":"30", "Id_Cliente":"66744""Fecha_Desde":"20210405", "Fecha_Hasta":"20210430", "Id_Grupo_Cont":"", "Id_SubGrupo_Cont":""}'
